
#ifndef TCSFeedbackMapsSteppable_H
#define TCSFeedbackMapsSteppable_H

#include <CompuCell3D/plugins/NeighborTracker/NeighborTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/BoundaryPixelTrackerPlugin.h>
#include <CompuCell3D/plugins/PixelTracker/PixelTrackerPlugin.h>
#include <CompuCell3D/Potts3D/EnergyFunction.h>
#include <CompuCell3D/Potts3D/Cell.h>
#include <CompuCell3D/Potts3D/Potts3D.h>
#include <CompuCell3D/Potts3D/CellGChangeWatcher.h>
#include <CompuCell3D/Steppable.h>
#include <CompuCell3D/Field3D/Dim3D.h>
#include <CompuCell3D/Field3D/Field3D.h>
#include <CompuCell3D/Field3D/WatchableField3D.h>

#include <string>
#include <BasicUtils/BasicRandomNumberGenerator.h>


#include <CompuCell3D/Steppable.h>
#include <CompuCell3D/Field3D/Dim3D.h>
#include <CompuCell3D/Field3D/Point3D.h>

#include <BasicUtils/BasicClassAccessor.h>

#include "../ClusterDataTrackerPlugin/ClusterDataTrackerPlugin.h"


//STL containers
#include <vector>
#include <list>
#include <set>
#include <map>


template <typename Y> class BasicClassAccessor;
namespace CompuCell3D {
    

  template <class T> class WatchableField3D;
  template <class T> class Field3DImpl;


    class Potts3D;
    class Automaton;
    class BoundaryStrategy;
    class CellInventory;
    class CellG;
    class Simulator;
    class BoundaryPixelTrackerPlugin;
    class PixelTrackerPlugin;
    class NeighborTrackerPlugin;
   
        
  class  TCSFeedbackMapsSteppable: public Steppable {
    WatchableField3D<CellG *> *fieldG;
    Simulator * sim;
    Potts3D *potts;
    CC3DXMLElement *xmlData;
    Automaton *automaton;
    BoundaryStrategy *boundaryStrategy;
    CellInventory * cellInventoryPtr;  	
    Dim3D fieldDim;
      
    BasicRandomNumberGenerator * rand; 
    unsigned int maxNeighborIndex;
    
//     Field3D<double> *FPDGFB; 
//     Field3D<double> *FLTGFb;
//     Field3D<double> *FTGFb; 
//     Field3D<double> *FuPAR;
//     Field3D<double> *FuPA;
    Field3D<float> *FuPARact;
    Field3D<float> *FVEGF;
    

  public:
      
        map<PixelTrackerData,float> pixelVEGFFeedbackMap;
        map<PixelTrackerData,float> getStorePixelVEGFFeedbackMap()
            {
            map<PixelTrackerData,float> map=pixelVEGFFeedbackMap;
            return map;
            }
      
        map<long int,map<string,double> > cellAndFeedbackMap;
        map<string,double> getStoreFeedbackMap(long int clusterId)
            {
            map<string,double> storeFeedbackMap;
            if (cellAndFeedbackMap.find(clusterId)!=cellAndFeedbackMap.end())
                {
                storeFeedbackMap=cellAndFeedbackMap[clusterId];
                }
            return storeFeedbackMap;
            }
            
        map<long int,double> cellAndFeedbackPixelsSizeMap;
        double getFeedbackPixelsSize(long int clusterId)
            {
            double size=0.0;
            if (cellAndFeedbackPixelsSizeMap.find(clusterId)!=cellAndFeedbackPixelsSizeMap.end())
                {
                size=cellAndFeedbackPixelsSizeMap[clusterId];
                }
            return size;
            }
  
    double deltaT;
    double OnlyAtBorder;
    double OnlyAtBasolateral;
    double contactCalculation;
    double negFBdelta;
    double posFBnotch;
    double VEGFfeedback;
    double cisSignal;
    double scalingDim;
    double structuredNoiseNotch;
    double structuredNoiseDelta;
    double VEGFR2haplo;
    double nomVEGF;
    
    
    double bN;
    double gN;
    double aN;
    double kN;
    double nN;
    
    double bD;
    double bDc;
    double gD;
    double aD;
    double nD;
    double kD;
    double mD;
    
    double kc;
    double kt;
    
    double gS;
    double aS;
    double nS;
    double kS;
 
    double bU;
    double gU;
    double aU;
    double kU;
    double nU;
    
    double kv;
    double bR;
    double bRc;
    double gR;
    double aR;
    double kR;
    double nR;
    double mR;
    
    double gA;
    double aA;
    double nA;
    double kA;       
            

        Field3DImpl<float>* getCCFieldByName(std::string _fieldName);
        //BasicClassAccessor<NeighborTracker> * neighborTrackerAccessorPtr;
        //NeighborTrackerPlugin *nTrackerPlugin;
        BasicClassAccessor <BoundaryPixelTracker> *bptAccessorPtr;
	BoundaryPixelTrackerPlugin *boundaryPixelTrackerPlugin;
        
        BasicClassAccessor <ClusterDataTrackerPlugin> *clusterDataTrackerAccessorPtr;
	ClusterDataTrackerPlugin *clusterDataTrackerPlugin;
        
        BasicClassAccessor <PixelTracker> *pixelTrackerAccessorPtr;
	PixelTrackerPlugin *pixelTrackerPlugin;

        NeighborTrackerPlugin *nTrackerPlugin;
        BasicClassAccessor<NeighborTracker> * neighborTrackerAccessorPtr;
        
    //functions
    set<Point3D> returnUPARpixels(CellG *cell,set<Point3D> membranePixelList);      
    std::map<long int,double>  getClusterNeighbors(long int clusterId);   
    
    TCSFeedbackMapsSteppable();
    virtual ~TCSFeedbackMapsSteppable();
    // SimObject interface
    virtual void init(Simulator *simulator, CC3DXMLElement *_xmlData=0);
    virtual void extraInit(Simulator *simulator);

    //steppable interface
    virtual void start();
    virtual void step(const unsigned int currentStep);
    virtual void finish() {}


    //SteerableObject interface
    virtual void update(CC3DXMLElement *_xmlData, bool _fullInitFlag=false);
    virtual std::string steerableName();
	 virtual std::string toString();
   

      protected:
    /**
     * @return The index used for ordering contact energies in the map.
     */

  };
};
#endif        
